function sompak_gui()

%SOMPAK_GUI  A GUI for using SOM_PAK functions from Matlab.
%
%  sompak_gui
%
% Launches a GUI which allows the use of SOM_PAK functions from
% Matlab. Notice that to use this function, the SOM_PAK programs must
% be in your search path, or the variable 'SOM_PAKDIR' which is a
% string containing the program path, must be defined in the
% workspace. SOM_PAK programs can be found from:
% http://www.cis.hut.fi/research/som_lvq_pak.shtml
%  
% See also SOM_GUI, SOMPAK_INIT_GUI, SOMPAK_SAMMON_GUI, SOMPAK_TRAIN_GUI.

% Contributed to SOM Toolbox 2.0, February 2nd, 2000 by Juha Parhankangas
% Copyright (c) by Juha Parhankangas
% http://www.cis.hut.fi/projects/somtoolbox/

% Juha Parhankangas 050100

h=findobj(get(0,'Children'),'Tag','sompak_gui');
if ~isempty(h)
  figure(h);
  return;
end

a = figure('Color',[0.8 0.8 0.8], ...
	'PaperType','a4letter', ...
	'Position',[689 536 210 70], ...
	'Tag','sompak_gui');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
        'Callback','sompak_init_gui',...
	'FontWeight','demi', ...
	'Position',[8 30 50 20], ...
	'String','INIT', ...
	'Tag','Pushbutton1');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
        'Callback','sompak_train_gui',...
	'FontWeight','demi', ...
	'Position',[63 30 50 20], ...
	'String','TRAIN', ...
	'Tag','Pushbutton2');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
        'Callback','sompak_sammon_gui',...
	'FontWeight','demi', ...
	'Position',[118 30 50 20], ...
	'String','SAMMON', ...
	'Tag','Pushbutton3');
b = uicontrol('Parent',a, ...
	'Units','points', ...
	'BackgroundColor',[0.701961 0.701961 0.701961], ...
	'Callback','close gcf', ...
	'FontSize',9, ...
	'FontWeight','demi', ...
	'Position',[128 5 40 15], ...
	'String','Close', ...
	'Tag','Pushbutton4');





